#!/usr/bin/env bash
set -x
set -e
#---------------------------------------
src=de
tgt=en

DATA_PATH=data-bin/iwslt14.rdrop.tokenized.de-en
MODEL_PATH=iwslt14.rdrop.de-en-ckpt-211
outfile=result.gen
rm -rf  $MODEL_PATH/result.gen*

export CUDA_VISIBLE_DEVICES=1


cat iwslt_test/test.de | python fairseq_src/fairseq_cli/interactive.py $DATA_PATH \
	--path $MODEL_PATH/checkpoint30.pt \
	-s $src -t $tgt \
	--beam 5 --lenpen 0.6 --remove-bpe \
	--buffer-size 2000 --batch-size 128 >> ${MODEL_PATH}/result.gen

grep -P "^D-[0-9]+" ${MODEL_PATH}/result.gen | cut -f3   > ${MODEL_PATH}/result.gen.sys

cat ${MODEL_PATH}/result.gen.sys | \
	sacremoses -l $tgt detokenize > ${MODEL_PATH}/result.gen.sys_detoken





















